/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.data;

import frc.emul.config.data.CfgItemAuthor;
import frc.emul.config.data.CfgItemCartridge;
import frc.emul.config.data.CfgItemCategory;
import frc.emul.config.data.CfgItemGame;
import frc.emul.util.Utils;
import java.io.File;

public class CfgItemGameInfo {
    private final CfgItemGame owner;
    public CfgItemAuthor author;
    public CfgItemCategory category;
    public String date;
    public String version;
    public String picPath;
    public String docPath;
    public String comments;
    public transient Integer romSize;
    public transient Long romCRC;

    CfgItemGameInfo(CfgItemGame cfgItemGame) {
        this.owner = cfgItemGame;
    }

    public boolean hasInfo() {
        return this.date != null && this.date.length() > 0 || this.version != null && this.version.length() > 0 || this.docPath != null && this.docPath.length() > 0 || this.picPath != null && this.picPath.length() > 0 || this.comments != null && this.comments.length() > 0 || this.author != null && !this.author.isDefault || this.category != null && !this.category.isDefault;
    }

    public int getBinarySize() {
        CfgItemCartridge cfgItemCartridge = this.owner.cartridge;
        if (this.romSize == null || cfgItemCartridge.picked) {
            int n = 0;
            if (this.owner.hasCartridge()) {
                if (!cfgItemCartridge.built) {
                    try {
                        n = this.owner.getCartridgeStream().getLength();
                    }
                    catch (Exception exception) {}
                }
            } else if ("MINESTORM".equals(cfgItemCartridge.id)) {
                n = 4096;
            }
            this.romSize = new Integer(n);
        }
        return this.romSize;
    }

    public long getBinaryCRC32() {
        CfgItemCartridge cfgItemCartridge = this.owner.cartridge;
        if (this.romCRC == null || cfgItemCartridge.picked) {
            long l = -1L;
            if (this.owner.hasCartridge()) {
                if (!cfgItemCartridge.built) {
                    l = Utils.getCRC32(this.owner.getCartridgeStream());
                }
            } else if ("MINESTORM".equals(cfgItemCartridge.id)) {
                l = Utils.getCRC32(new File(this.owner.systemRom.path));
            }
            this.romCRC = new Long(l);
        }
        return this.romCRC;
    }

    public String getFilenameCandidate(String string, boolean bl) {
        if (string == null) {
            string = "unnamed";
        }
        String string2 = Utils.escapeFileNamePart(this.owner.getID(), string);
        if (bl) {
            string2 = String.valueOf(string2) + "_" + Utils.hex(8, (int)this.getBinaryCRC32());
        }
        return string2;
    }
}

